import matplotlib.pyplot as plt
import pandas as pd

def plot_poland_vs_germany_cases(poland_csv_path, germany_csv_path, save_path):
    # Population data
    population_germany = 83.28e6    # 83.28 million
    population_poland = 36.69e6     # 36.69 million

    poland = pd.read_csv(poland_csv_path)
    poland['date'] = pd.to_datetime(poland['date'])
    germany = pd.read_csv(germany_csv_path)
    germany['date'] = pd.to_datetime(germany['date'])

    # Normalize new cases per million
    poland['new_cases_per_million'] = (poland['new_cases'] / population_poland) * 1e6
    germany['new_cases_per_million'] = (germany['new_cases'] / population_germany) * 1e6

    # Define base font size and calculate the 40% increased size
    base_font_size = plt.rcParams['font.size'] # Get default font size
    increased_font_size = base_font_size * 1.7

    fig, ax = plt.subplots(figsize=(12, 8)) # Changed from (12, 7) to (12, 8) for taller aspect ratio, and got ax object
    ax.plot(poland['date'], poland['new_cases_per_million'], color='blue', alpha=0.6, label='Poland')
    ax.plot(germany['date'], germany['new_cases_per_million'], color='orange', alpha=0.6, label='Germany')

    # Set only labels up to '2024-04'
    cutoff_date = pd.to_datetime('2024-04-30')
    germany_truncated = germany[germany['date'] <= cutoff_date]

    ax.set_xticks(
        ticks=germany_truncated['date'].iloc[::max(1, len(germany_truncated)//10)], # Adjust step to have around 5 labels
        labels=germany_truncated['date'].iloc[::max(1, len(germany_truncated)//10)].dt.strftime('%Y-%m'),
        rotation=45
    )
    ax.tick_params(axis='x', labelsize=increased_font_size * 0.9) # Increased font size for x-axis ticks
    ax.tick_params(axis='y', labelsize=increased_font_size * 0.9) # Increased font size for y-axis ticks

    ax.set_xlabel('Date', fontsize=increased_font_size) # Increased font size
    ax.set_ylabel('New Cases per Million', fontsize=increased_font_size) # Increased font size
    ax.set_title('New COVID-19 Cases per million people: Poland vs Germany', fontsize=16 * 1.4) # Increased font size
    legend = ax.legend(fontsize=increased_font_size * 0.9) # Increased font size for legend
    for line in legend.get_lines():
        line.set_linewidth(15)  # Adjust the linewidth as needed
    ax.set_xlim(None, cutoff_date)  # Set the x-axis limit
    plt.tight_layout()
    plt.savefig(save_path)
    plt.show()
