import pandas as pd

def fill(df):
    """
    Takes dataframe
    fills many NaN's, see the code below:
    """

    columns_to_fill_nans_with_zero = ['weekly_hosp_admissions', 'icu_patients', 'weekly_icu_admissions', 'reproduction_rate']
    df[columns_to_fill_nans_with_zero] = df[columns_to_fill_nans_with_zero].fillna(0)
    df['date'] = pd.to_datetime(df['date'])
    df['year'] = df['date'].dt.year
    df['month'] = df['date'].dt.month
    df['total_tests'] = df['total_tests'].ffill().fillna(0)
    df['total_vaccinations'] = df['total_vaccinations'].ffill().fillna(0)
    df['people_vaccinated'] = df['people_vaccinated'].ffill().fillna(0)
    df['people_fully_vaccinated'] = df['people_fully_vaccinated'].ffill().fillna(0)
    df['positive_rate'] = df['positive_rate'].interpolate(method='linear').fillna(0)
    df['tests_per_case'] = df['tests_per_case'].interpolate(method='linear').fillna(0)
    df['excess_mortality_cumulative_per_million'] = df['excess_mortality_cumulative_per_million'].interpolate(method='linear').fillna(0)
    return df
