import sys
import os
import pandas as pd

def main():
    if len(sys.argv) != 3:
        print("Usage: python3 make_ts_plots.py <0=show / 1=save> <script_name (without .py)>")
        return

    # Args
    show_or_save = sys.argv[1]
    script_name = sys.argv[2]

    if show_or_save not in {"0", "1"}:
        print("First argument must be 0 (show) or 1 (save).")
        return

    # Conversion to int
    show_or_save = int(show_or_save)

    # Select a scripts
    if script_name == "sarima_early":
        df = pd.read_csv("data/germany_early.csv")
        from scripts.ts_plots.sarima_early import forecast_plot
        forecast_plot(df, show_or_save)

    elif script_name == "sarima_late":
        df = pd.read_csv("data/germany_late.csv")
        from scripts.ts_plots.sarima_late import forecast_plot
        forecast_plot(df, show_or_save)

    else:
        print(f"Script '{script_name}' is not recognized.")

if __name__ == "__main__":
    main()
