import pandas as pd
from scripts.static_covid_plots.plot1_cases_vs_deaths import plot_cases_vs_deaths
from scripts.static_covid_plots.plot2_poland_vs_germany_cases import plot_poland_vs_germany_cases
from scripts.static_covid_plots.plot3_poland_vs_germany_cases_deaths import plot_cases_and_scaled_deaths
from scripts.static_covid_plots.plot4_poland_vs_germany_total_tests import plot_total_tests_per_million

df = pd.read_csv("data/germany_whole.csv")

plot_cases_vs_deaths(df, 'images/plot1_cases_vs_deaths.png')
print("Png 1 saved in 'images/plot1_cases_vs_deaths.png'")

plot_poland_vs_germany_cases(
    'data/poland_whole.csv',
    'data/germany_whole.csv',
    'images/plot2_poland_vs_germany_cases.png'
)
print("Png 2 saved in 'images/plot2_poland_vs_germany_cases.png'")


plot_cases_and_scaled_deaths(
    'data/poland_whole.csv',
    'data/germany_whole.csv',
    'images/plot3_poland_vs_germany_cases_deaths_scaled.png'
)
print("Png 3 saved in 'images/plot3_poland_vs_germany_cases_deaths_scaled.png'")

plot_total_tests_per_million(
    'data/poland_whole.csv',
    'data/germany_whole.csv',
    'images/plot4_poland_vs_germany_total_tests.png'
)
print("Png 4 saved in 'images/plot4_poland_vs_germany_total_tests.png'")
