import os
import base64
from pathlib import Path

# Paths
image_dir = Path("images")
output_html = Path("report.html")

# Collect files
image_files = sorted(image_dir.glob("*.png")) + sorted(image_dir.glob("*.gif"))
iframe_files = sorted(image_dir.glob("*.html"))

# HTML start
html_content = [
    "<!DOCTYPE html>",
    "<html lang='en'>",
    "<head>",
    "    <meta charset='UTF-8'>",
    "    <meta name='viewport' content='width=device-width, initial-scale=1.0'>",
    "    <title>COVID GERMANY</title>",
    "    <style>",
    "        body { font-family: Arial, sans-serif; text-align: center; margin: 20px; }",
    "        img { max-width: 90%; height: auto; margin: 20px 0; border: 1px solid #ccc; box-shadow: 2px 2px 10px rgba(0,0,0,0.1); }",
    "        iframe { margin: 40px 0; border: 1px solid #ccc; box-shadow: 2px 2px 10px rgba(0,0,0,0.1); }",
    "    </style>",
    "</head>",
    "<body>",
    "    <h1>COVID GERMANY</h1>",
]

# Embed images
for img_path in image_files:
    with open(img_path, "rb") as img_file:
        img_data = base64.b64encode(img_file.read()).decode("utf-8")
        ext = img_path.suffix.lower()[1:]  # png/gif
        mime_type = f"image/{'gif' if ext == 'gif' else 'png'}"
        html_content.append(f"<h3>{img_path.name}</h3>")
        html_content.append(f"<img src='data:{mime_type};base64,{img_data}' alt='{img_path.name}'>")

# Embed HTML files as iframe
for iframe_path in iframe_files:
    html_content.append(f"<h3>{iframe_path.name}</h3>")
    html_content.append(
        f"<iframe src='{iframe_path.as_posix()}' width='100%' height='600' frameborder='0'></iframe>"
    )

# Closing HTML tags
html_content.append("</body>")
html_content.append("</html>")

# Write to file
with open(output_html, "w", encoding="utf-8") as f:
    f.write("\n".join(html_content))

print(f"✅ Generated report.html with embedded images and HTML files as iframes.")
