import pandas as pd
import time
import warnings
from scripts.animations.covid_cases_animation import create_covid_animation_with_macro
warnings.filterwarnings("ignore")

cases = pd.read_csv("data/germany_whole.csv")
inflation = pd.read_csv("data/germany_inflation.csv")
unemployment = pd.read_csv("data/germany_unemployment.csv")

print("Working on cases, inflation and unemployment data from germany.")
print("Expected time of making animation: 27 seconds.\nMaking animation...")

time_start = time.time()
create_covid_animation_with_macro(cases, inflation, unemployment, "images/germany_covid_macro.gif")
time_end = time.time()
print("Animation successfully completed! Saved in 'images/germany_covid_macro.gif'")
print(f"Execution time: {time_end - time_start:.2f} seconds")
