### State of the project for 1.06.2025

# Data source:
    -- https://raw.githubusercontent.com/owid/covid-19-data/refs/heads/master/public/data/owid-covid-data.csv

# How to run everything
Whole project is completed. Anyone can check for functions and use them. 
However in case if someone wants to run scripts: it may be necessary to pip install some libraries. 
To do so, just run these commands in main folder (root of this project):
    -- python3 -m venv venv
    -- source venv/bin/activate
    -- pip install -r requirements.txt
Every needen library is contained in 'requirements.txt' file.

# How to see report.html
    -- The report.html file is plased in root folder of this project. It contains .html files as iframe with file path reference
    -- To see everything inside, make sure there is images/ folder with plots, that is placed also in the root folder.

# Project's general structure:
    -- main folder:
        -- functions for data preparation
        -- functions for making plots
        -- functions for making reports, cleaning the project from __pycache__
        -- contains README.md, requirements.txt, report.html, poster.pdf

    -- 'data' folder
        -- contains data for Poland && Germany
        -- separated with respect to:
            -- whole dataset with covid cases && features for data analysis
            -- unemployment && inflation data
            -- datasets with lags for RandomForrestRegressor.feature_importance_ analysis

    -- 'images'
        -- static plots in .png format
        -- interactife plots in .html format
        -- animations in .gif format

    -- 'scripts' (with 6 subfolders). Each folder has a script with one function for making a plot or (in case of 'io') for data preparation and cleaning. '- reference:' refers to a script that activates such functions.
        -- animations: making  .gif  - reference: 'make_animations.py'; goal: making Germany covid macroeconomics animation
        -- feature_importance: .png  - reference: 'make_feature_importance.py'; goal: searching for most important features in each time period
        -- interactive_plots: .html  - reference: 'make_interactive_plots.py'; goal: making interactive plots for comparison of cases, economics, mortality in both Poland and Germany
        -- io: data cleaning and preparations  - reference: run_cleaning_poland.py && run_cleaning_germany.py; goal: processing raw datasets, creates new tables. After calling python3 run_cleaning_{country}.py many informations are displayed.
        -- static_covid_plots: .pnd  - reference: 'make_static_plots.py'; goal: making static plots that compare Poland and Germany metrics and give insights to covid cases in those countries.
        -- ts_plots: .png  - reference: 'make_ts_plots.py'; goal: forecasting, time series analysis. Checking if some models are good in predicting future cases. Model used: SARIMA(1,1,0)(2,1,1)[7] and SARIMA(2,1,0)(2,2,0)[7] for 40 days forecasting. 



# Main functionalities:
    -- python3 clear_pycache.py : 
        -- it deleated every __pycache__ file in the project

    -- python3 run_cleaning_germany.py:
    -- python3 run_cleaning_poland.py:
        -- process raw dataframes. No need to use it (every important file is already in a project)

    -- python3 make_animations.py
    -- python3 make_feature_importance.py
    -- python3 make_interactive_plots.py
    -- python3 make_static_plots.py
    -- python3 make_ts_plots.py


