import pandas as pd
import plotly.graph_objects as go

df = pd.read_csv("data/dpc-covid19-ita-regioni.csv", parse_dates=["data"])

italy_region = df.rename(columns={
    "denominazione_regione": "region_name",
    "totale_positivi": "cumulative_positive_cases",
    "deceduti": "death",
    "dimessi_guariti": "recovered",
    "totale_casi": "cumulative_cases"
})

latest = italy_region[italy_region["data"] == italy_region["data"].max()].copy()
latest = latest[["region_name", "cumulative_positive_cases", "recovered", "death", "cumulative_cases"]]
latest = latest.sort_values("cumulative_cases", ascending=False)
latest["region"] = pd.Categorical(latest["region_name"], categories=latest["region_name"], ordered=True)

fig = go.Figure()

fig.add_trace(go.Bar(
    y=latest["region"],
    x=latest["cumulative_positive_cases"],
    name="Active",
    orientation="h",
    text=latest["cumulative_positive_cases"],
    textposition="auto",
    marker=dict(color="#1f77b4")
))

fig.add_trace(go.Bar(
    y=latest["region"],
    x=latest["recovered"],
    name="Recovered",
    orientation="h",
    text=latest["recovered"],
    textposition="auto",
    marker=dict(color="forestgreen")
))

fig.add_trace(go.Bar(
    y=latest["region"],
    x=latest["death"],
    name="Death",
    orientation="h",
    text=latest["death"],
    textposition="auto",
    marker=dict(color="red")
))

fig.update_layout(
    barmode='stack',
    title=dict(
        text='Cases Distribution by Region',
        font=dict(size=24)
    ),
    xaxis=dict(
        title=dict(text='Number of Cases', font=dict(size=19)),
        tickfont=dict(size=15)
    ),
    yaxis=dict(
        title=dict(text='Region', font=dict(size=19)),
        tickfont=dict(size=15)
    ),
    legend=dict(
        title=dict(text='Legend', font=dict(size=17)),
        font=dict(size=15),
        x=0.65, 
        y=0.9
    ),
    font=dict(size=13),
    hovermode='x unified',
    # margin=dict(l=20, r=10, b=10, t=30, pad=2)
)

fig.show()
fig.write_html('plots/cases_distribution_region.html')