# COVID-19 analysis in France
Project for Data analysis and visualization course that shows some statistics and plots about COVID-19 pandemic in France. We focused on the level of infections and deaths, as well as the response to the disease: vaccinations and hospitalization.

## Data sources
For France:

    https://www.data.gouv.fr/fr/datasets/synthese-des-indicateurs-de-suivi-de-lepidemie-covid-19/
    https://www.data.gouv.fr/fr/datasets/donnees-de-laboratoires-pour-le-depistage-a-compter-du-18-05-2022-si-dep/
    https://www.data.gouv.fr/fr/datasets/departements-de-france/
    https://www.legifrance.gouv.fr/loda/id/JORFTEXT000050935068?init=true&page=1&query=authentifiant+les+chiffres+des+populations+de+m%C3%A9tropole%2C+des+d%C3%A9partements+d%27outre-mer&searchField=ALL&tab_selection=all

For Poland:

    https://github.com/owid/covid-19-data/tree/master/public/data

## Statistics

### General summary

|Description | Number | 
| --- | --- | 
|Confirmed cases| 40,138,560 | 
|Deaths | 167,642 |
|Fatality rate | 0.57% |
|Total vaccinated | 54,677,680 |


### Region summary (30.06.2023)
|           Region           | Total Cases | Cases per 100 | Total Deaths | Vaccination Rate |
| --- | --- | --- | --- | --- |
|  Auvergne et Rhône-Alpes   |   4936842   |     71.32     |    18403     |       83.8       |
| Bourgogne et Franche-Comté |   1550459   |     53.98     |     7508     |       83.1       |
|          Bretagne          |   1799348   |     51.67     |     3728     |       85.9       |
|    Centre-Val de Loire     |   1323435   |     50.31     |     4669     |       83.7       |
|           Corse            |    204801   |     58.09     |     540      |       70.6       |
|         Grand Est          |   3194661   |     59.26     |    15174     |       82.0       |
|         Guadeloupe         |    209172   |     53.73     |     1160     |       40.8       |
|           Guyane           |    98352    |     34.06     |     416      |       34.1       |
|      Hauts-de-France       |   3446288   |     62.13     |    13985     |       82.3       |
|         Martinique         |    232251   |     63.65     |     1168     |       43.0       |
|          Mayotte           |    40536    |      nan      |     166      |       54.2       |
|         Normandie          |   1742636   |     51.28     |     5679     |       86.3       |
|     Nouvelle Aquitaine     |   3300204   |     53.17     |     8048     |       85.4       |
|         Occitanie          |   3559907   |     59.47     |     9418     |       81.3       |
|      Pays de la Loire      |   2066837   |      52.4     |     4732     |       85.4       |
| Provence-Alpes-Côte d'Azur |   3324009   |     88.21     |    14438     |       78.5       |
|          Réunion           |    528504   |      60.0     |     1009     |       66.8       |
|       Île-de-France        |   7095470   |     57.09     |    29350     |       83.4       |


## Plots

1. France Hospitalizations Forecast (SARIMAX)
2. France Deaths Forecast (SARIMAX)
3. COVID-19 Deaths: Poland vs France
4. Weekly number of new hospitalisations, deaths and reanimations in France (static & gif)
5. COVID-19 Hospitalizations per 100,000 People: Poland vs France
6. Daily Hospitalizations in France by Year
7. Daily number of corfirmed new COVID-19 cases in France per Region
8. COVID-19 vaccination coverage in France
9. COVID-19 Total Deaths in Metropolitan France by Department
10. COVID-19 Total Deaths per 100k Residents in Metropolitan France by Department
11. COVID-19 Total Cases in Metropolitan France by Department 
12. COVID-19 Total Cases per 100k residents in Metropolitan France by Department 
13. COVID-19 hospitalizations in France
14. COVID-19 deaths in France
