import pandas as pd
import matplotlib.pyplot as plt

# Load data
df = pd.read_csv("../data/england_vaccinations.csv")
df["date"] = pd.to_datetime(df["date"])

# General plot
plt.figure(figsize=(12, 6))
plt.plot(df["date"], df["total_vaccinations"], label="Total vaccinations", color="blue")
plt.plot(df["date"], df["people_vaccinated"], label="At least 1 dose", color="green")
plt.plot(df["date"], df["people_fully_vaccinated"], label="Fully vaccinated", color="orange")
plt.plot(df["date"], df["total_boosters"], label="Boosters", color="purple")
plt.title("COVID-19 Vaccination Progress in England")
plt.xlabel("Date")
plt.ylabel("Number of people")
plt.legend()
plt.grid(True)
plt.tight_layout()
plt.savefig("../plots/vaccination_progress1.png", dpi=300)
plt.show()
