import pandas as pd
import matplotlib.pyplot as plt

# Load data
df = pd.read_csv("../data/united_kingdom_covid.csv")
df['Date'] = pd.date_range(start='2020-01-01', periods=len(df), freq='D')
df['Year'] = df['Date'].dt.year

# Yearly aggregation (sum)
yearly = df.groupby('Year').agg({
    'Total confirmed cases of COVID-19': 'max',
    'Total confirmed deaths due to COVID-19': 'max'
}).reset_index()

# Calculate death-to-case ratio
yearly['Death ratio (%)'] = yearly['Total confirmed deaths due to COVID-19'] / yearly['Total confirmed cases of COVID-19'] * 100

# Generate pie charts for each year
for _, row in yearly.iterrows():
    labels = ['Deaths', 'Cases']
    sizes = [
        row['Total confirmed deaths due to COVID-19'],
        row['Total confirmed cases of COVID-19'] - row['Total confirmed deaths due to COVID-19']
    ]
    plt.figure(figsize=(6, 6))
    plt.pie(sizes, labels=labels, autopct='%1.1f%%', colors=['orange', 'blue'], startangle=90)
    plt.title(f'Death-to-Case Ratio in {int(row["Year"])}')
    plt.savefig(f'../plots/1pie_death_ratio_{int(row["Year"])}.png')
    plt.close()

