import pandas as pd
import matplotlib.pyplot as plt

# Load data
df = pd.read_csv("../data/united_kingdom_covid.csv")
df['Date'] = pd.date_range(start='2020-01-01', periods=len(df), freq='D')
df['Year'] = df['Date'].dt.year

# Aggregate: sum daily cases by year
yearly_cases = df.groupby('Year')['Daily new confirmed cases of COVID-19'].sum().reset_index()

# Create pie chart
plt.figure(figsize=(8, 8))
colors = plt.get_cmap('tab20').colors  

plt.pie(yearly_cases['Daily new confirmed cases of COVID-19'], 
        labels=yearly_cases['Year'], 
        autopct='%1.1f%%',
        colors=colors,
        startangle=90,
        wedgeprops={'edgecolor': 'black'})

plt.title('Share of Total COVID-19 Cases by Year')
plt.savefig('../plots/1pie_cases_by_year.png')
plt.close()
