import pandas as pd
import geopandas as gpd
import folium
from branca.colormap import linear

gdf = gpd.read_file("data/Local_Authority_Districts_December_2021_UK_BGC_2022_8356726426853823028/LAD_DEC_2021_UK_BGC.shp")
gdf = gdf.rename(columns={"LAD21CD": "AreaCode", "LAD21NM": "Region"})

covid = pd.read_csv('data/england-cases.csv')  
covid['Date'] = pd.to_datetime(covid['Date'])

date_to_show = covid['Date'].max()
covid_day = covid[covid['Date'] == date_to_show]


merged = gdf.merge(covid_day[['AreaCode', 'TotalCases', 'Date']], on='AreaCode', how='left')
merged['TotalCases'] = merged['TotalCases'].fillna(0)

merged['Date'] = merged['Date'].astype(str)

max_cases = merged['TotalCases'].max()
colormap = linear.OrRd_09.scale(0, max_cases)
colormap.caption = 'Total COVID-19 Cases'

m = folium.Map(location=[54.5, -2], zoom_start=6, tiles='cartodbpositron')

folium.GeoJson(
    merged,
    style_function=lambda feature: {
        'fillColor': colormap(feature['properties']['TotalCases']),
        'color': 'black',
        'weight': 0.5,
        'fillOpacity': 0.7,
    },
    tooltip=folium.GeoJsonTooltip(
        fields=['Region', 'TotalCases', 'Date'],
        aliases=['Region:', 'Total Cases:', 'Date:'],
        localize=True
    )
).add_to(m)

colormap.add_to(m)

m.save('plots/covid_map_total_cases.html')
print("Mapa z total cases zapisana w 'plots/covid_map_total_cases.html'")
