import pandas as pd
import geopandas as gpd
import matplotlib.pyplot as plt

gdf = gpd.read_file("data/Local_Authority_Districts_December_2021_UK_BGC_2022_8356726426853823028/LAD_DEC_2021_UK_BGC.shp")

covid = pd.read_csv("data/england-cases.csv")
covid['Date'] = pd.to_datetime(covid['Date'])

latest_date = covid['Date'].max()
covid_today = covid[covid['Date'] == latest_date]

gdf = gdf.rename(columns={"LAD21CD": "AreaCode"})
merged = gdf.merge(covid_today, on="AreaCode", how="left")

fig, ax = plt.subplots(1, 1, figsize=(12, 14))

gdf.boundary.plot(ax=ax, linewidth=0.5, color="gray")

merged.plot(column="DailyCases",
            ax=ax,
            cmap="Reds",
            linewidth=0.8,
            edgecolor="black",
            legend=True,
            missing_kwds={"color": "lightgrey", "label": "No data"})

ax.set_title(f"COVID-19 Daily Cases by Local Authority\nDate: {latest_date.strftime('%Y-%m-%d')}", fontsize=16)
ax.axis("off")

plt.savefig("plots/covid_cases_colormap.png", dpi=300, bbox_inches='tight')
plt.show()
