import pandas as pd
import matplotlib.pyplot as plt

# Load the data
df = pd.read_csv("data/ukhsa_daily_vaccinations.csv")

# Filter the data: keep only the relevant metric
df = df[df['metric'] == "COVID-19_vaccinations_autumn24_dosesByDay"]

# Convert the date column to datetime
df['date'] = pd.to_datetime(df['date'])

# Sort by date in ascending order (in case it's not already)
df = df.sort_values('date')

# Plotting
plt.figure(figsize=(12, 5))
plt.plot(df['date'], df['metric_value'], marker='o', color='green', linewidth=2)

plt.title("People Aged 65+ Receiving Autumn Booster (England)", fontsize=14)
plt.xlabel("Vaccination Date")
plt.ylabel("Number of Doses (Daily)")
plt.grid(True, linestyle='--', alpha=0.5)

# Rotate x-axis labels for clarity
plt.xticks(rotation=45)
plt.tight_layout()

plt.savefig("plots/autumn_booster_65plus.png", dpi=300)
plt.show()

