# covid_per_capita.py
import pandas as pd
import matplotlib.pyplot as plt

df = pd.read_csv("../data/united_kingdom_covid.csv")
df['Date'] = pd.date_range(start='2020-01-01', periods=len(df), freq='D')

# Fill NaN values with zeros
df['Daily cases per million'] = df['Daily new confirmed cases of COVID-19 per million people'].fillna(0)
df['Daily deaths per million'] = df['Daily new confirmed deaths due to COVID-19 per million people'].fillna(0)

plt.figure(figsize=(12, 6))
plt.plot(df['Date'], df['Daily cases per million'], label='Cases per million', color='blue')
plt.plot(df['Date'], df['Daily deaths per million'], label='Deaths per million', color='red')
plt.title("Daily COVID-19 Cases and Deaths per Million People (UK)")
plt.xlabel("Date")
plt.ylabel("Count per Million People")
plt.legend()
plt.grid(True)
plt.tight_layout()
plt.savefig("../plots/per_capita_daily1.png")
plt.close()
