import pandas as pd
import matplotlib.pyplot as plt

df = pd.read_csv("../data/united_kingdom_covid.csv")
df['Date'] = pd.date_range(start='2020-01-01', periods=len(df), freq='D')

df['Total cases'] = df['Total confirmed cases of COVID-19'].ffill().fillna(0)
df['Total deaths'] = df['Total confirmed deaths due to COVID-19'].ffill().fillna(0)

fig, ax1 = plt.subplots(figsize=(12, 6))

# Plot total cases
ax1.fill_between(df['Date'], df['Total cases'], color='blue', alpha=0.4)
ax1.set_xlabel('Date')
ax1.set_ylabel('Total cases', color='blue')
ax1.tick_params(axis='y', labelcolor='blue')

# Plot total deaths on secondary Y-axis
ax2 = ax1.twinx()
ax2.fill_between(df['Date'], df['Total deaths'], color='red', alpha=0.4)
ax2.set_ylabel('Total deaths', color='red')
ax2.tick_params(axis='y', labelcolor='red')

plt.title('Cumulative COVID-19 Cases and Deaths in the UK (Dual Y-Axis)')
plt.tight_layout()
plt.savefig("../plots/cumulative_area_dual_axis1.png")
plt.close()
