import pandas as pd
import matplotlib.pyplot as plt

def plot_cfr(df, country_name):
    df = df[df['Country'] == country_name].copy()
    df['Date'] = pd.to_datetime('2020-01-01') + pd.to_timedelta(df.index, unit='D')
    
    # CFR mamy w kolumnie 'Case fatality rate of COVID-19 (%)'
    plt.figure(figsize=(14,6))
    plt.plot(df['Date'], df['Case fatality rate of COVID-19 (%)'], label='CFR (%)')
    plt.title(f'Case Fatality Rate (CFR) in {country_name}')
    plt.xlabel('Date')
    plt.ylabel('CFR (%)')
    plt.legend()
    plt.tight_layout()
    plt.savefig(f'plots/{country_name}_cfr.png')
    plt.show()

if __name__ == '__main__':
    uk_df = pd.read_csv('data/united_kingdom_covid.csv')
    plot_cfr(uk_df, 'United Kingdom')
