import pandas as pd
import matplotlib.pyplot as plt

def load_data(path):
    return pd.read_csv(path)

def plot_cases_time_series(df, country_name):
    df = df[df['Country'] == country_name].copy()
    df['Date'] = pd.to_datetime(df['Year'], errors='coerce') 
    
   
    df['Date'] = pd.to_datetime('2020-01-01') + pd.to_timedelta(df.index, unit='D')
    
    plt.figure(figsize=(14,6))
    plt.plot(df['Date'], df['Daily new confirmed cases of COVID-19'], label='Daily New Cases')
    plt.plot(df['Date'], df['Daily new confirmed cases due to COVID-19 (rolling 7-day average, right-aligned)'], label='7-day Rolling Average')
    plt.title(f'Daily New COVID-19 Cases in {country_name}')
    plt.xlabel('Date')
    plt.ylabel('Number of Cases')
    plt.legend()
    plt.tight_layout()
    plt.savefig(f'plots/{country_name}_cases_time_series.png')
    plt.show()

if __name__ == '__main__':
    uk_df = load_data('data/united_kingdom_covid.csv')
    plot_cases_time_series(uk_df, 'United Kingdom')
