import pandas as pd
import matplotlib.pyplot as plt

# Load the data
df = pd.read_csv("data/ukhsa_sex.csv")

# Convert the date column to datetime
df['date'] = pd.to_datetime(df['date'])

# Filter only the relevant metric
df_filtered = df[df['metric'] == "COVID-19_cases_rateRollingMean"]

# Pivot the DataFrame so that sex becomes columns
pivot = df_filtered.pivot(index="date", columns="sex", values="metric_value")

# Plot
plt.figure(figsize=(12, 6))
plt.plot(pivot.index, pivot['m'], label='Male', color='blue')
plt.plot(pivot.index, pivot['f'], label='Female', color='red')

plt.title('COVID-19 Case Rates by Specimen Date and Sex', fontsize=16)
plt.xlabel('Date')
plt.ylabel('Case Rate (Rolling Mean)')
plt.legend()
plt.grid(True)
plt.tight_layout()

plt.savefig('plots/case_rates_by_sex.png')
plt.show()
