# biweekly_growth_scatter.py
import pandas as pd
import matplotlib.pyplot as plt

df = pd.read_csv("../data/united_kingdom_covid.csv")

# Fill NaN values with zeros to avoid errors
df['Biweekly case growth (%)'] = df['Biweekly case growth (%)'].fillna(0)
df['Biweekly death growth (%)'] = df['Biweekly death growth (%)'].fillna(0)

plt.figure(figsize=(8, 6))
plt.scatter(df['Biweekly case growth (%)'], df['Biweekly death growth (%)'], alpha=0.5, color='purple')
plt.axhline(0, color='grey', linestyle='--', linewidth=0.7)
plt.axvline(0, color='grey', linestyle='--', linewidth=0.7)
plt.title("Biweekly Case Growth vs Death Growth (%)")
plt.xlabel("Biweekly Case Growth (%)")
plt.ylabel("Biweekly Death Growth (%)")
plt.grid(True)
plt.tight_layout()
plt.savefig("../plots/biweekly_growth_scatter1.png")
plt.close()

