import pandas as pd
import matplotlib.pyplot as plt

# Load the data
df = pd.read_csv("data/ukhsa_per_vacc.csv")

# Filter only the uptake metric for autumn vaccinations
df = df[df['metric'] == "COVID-19_vaccinations_autumn24_uptakeByDay"]

# Convert dates
df['date'] = pd.to_datetime(df['date'])

# Sort the data
df = df.sort_values('date')

# Ensure age is treated as string for labeling
df['age'] = df['age'].astype(str)

# Plotting
plt.figure(figsize=(14, 6))

for age_group in df['age'].unique():
    subset = df[df['age'] == age_group]
    plt.plot(subset['date'], subset['metric_value'], label=f'Age {age_group}', linewidth=2)

plt.title("Autumn Booster Vaccination Uptake (65+), by Vaccination Date", fontsize=14)
plt.xlabel("Date")
plt.ylabel("Uptake (%)")
plt.ylim(0, 100)
plt.legend(title="Age Group")
plt.grid(True, linestyle='--', alpha=0.5)
plt.xticks(rotation=45)
plt.tight_layout()

plt.savefig("plots/autumn_booster_uptake_by_age.png", dpi=300)
plt.show()
