import pandas as pd
import plotly.graph_objs as go
import plotly.io as pio


df = pd.read_csv("../data/england_vaccinations.csv")
df["date"] = pd.to_datetime(df["date"])

frames = []
for i in range(1, len(df)+1):
    frame = go.Frame(
        data=[
            go.Scatter(x=df["date"][:i], y=df["total_vaccinations"][:i], mode='lines', name='Total vaccinations', line=dict(color='blue')),
            go.Scatter(x=df["date"][:i], y=df["people_vaccinated"][:i], mode='lines', name='At least 1 dose', line=dict(color='green')),
            go.Scatter(x=df["date"][:i], y=df["people_fully_vaccinated"][:i], mode='lines', name='Fully vaccinated', line=dict(color='orange')),
            go.Scatter(x=df["date"][:i], y=df["total_boosters"][:i], mode='lines', name='Boosters', line=dict(color='purple')),
        ],
        name=str(i)
    )
    frames.append(frame)

layout = go.Layout(
    title="COVID-19 Vaccination Progress in England",
    xaxis=dict(title='Date', range=[df["date"].min(), df["date"].max()]),
    yaxis=dict(title='Number of people', range=[0, df[["total_vaccinations", "people_vaccinated", "people_fully_vaccinated", "total_boosters"]].max().max()*1.05]),
    updatemenus=[dict(
        type="buttons",
        buttons=[dict(label="Play",
                      method="animate",
                      args=[None, {"frame": {"duration": 50, "redraw": True}, "fromcurrent": True}])])]
)


data = frames[0].data

fig = go.Figure(data=data, frames=frames, layout=layout)


pio.write_html(fig, file="../plots/vaccination_progress_interactive.html", auto_open=True)
