
function U=struna(N,u0,v0,T,M)
#rozwiazanie zad struny u_{tt}=u_{xx}-0.1u_t
#z u(t,0)=u(t,1)=0 z u0=u(0,x),v0=u_t(0,x)
# na siatce rownomiernej N+1 na [0,1] tzn x_k=k*h k=1,..,N
#N ilosc punktów wewnatrz (h=1/(N+1))
#u0=u(0,x),v0=u_t(0,x) - warunki poczatkowe w punktach siatki
#T- czas tzn szukamy rozwiazania na [0,T]
#M ilosc punktow czasu tzn \tau =T/M \tau_n=n*\tau n=0,..,M
#funkcja zwraca U macierz (M+1)xN (w k-tym wierszu U(k,:)
#rozwiazanie dyskretne wew. odcinka dla t_k=(k-1)*\tau k=0,..,M)   

 global A NN
 NN=N;
 tau=(1.0*T)/(M);

 x=ones(N,1);
 A=-spdiag(2*x)+spdiag(x(1:N-1),1)+spdiag(x(1:N-1),-1);

 tt=linspace(0,T,M+1);
 X0=[u0; v0];
 U=lsode("pw",X0,tt);
#wycinamy wartości (bo U zawiera też dyskretne pochodne U(:,(N+1):2*N)
 U=U(:,1:N);
endfunction

function y=pw(x)
   #pole wektorowe u''=h^{-2}*A*x -0.1*u'
   #u'=v; v'=h^{-2}*A*x-0.1*v

   global A NN 
   y=zeros(2*NN,1);

   y(1:NN)=x((NN+1):2*NN);
   y((NN+1):2*NN)=(NN+1)*(NN+1)*A*x(1:NN)-0.2*x((NN+1):2*NN);
  endfunction
