signature REGISTER8 =
sig
	eqtype reg8;
	exception REGISTER8_ERROR of string;

	structure Bitfield : BITFIELD;
	structure Bit : BIT;
	sharing Bit = Bitfield.Bit;

	type flags;

	val maxSigned : int;
	val maxUnsigned : int;
	val minSigned : int;
	val minUnsigned : int;

	val setBit : int -> reg8 -> reg8;
	val resetBit : int -> reg8 -> reg8;
	val negateBit : int -> reg8 -> reg8;

	val isSet : int -> reg8 -> bool;
	val isNotSet : int -> reg8 -> bool;

	val asSigned : reg8 -> int;
	val asUnsigned : reg8 -> int;

	val fromInt : int -> reg8;
	val new : reg8;
	val zero : reg8;

	val getBit : int -> reg8 -> Bit.bit;
	val putBit : int -> Bit.bit -> reg8 -> reg8;

	val andBits : reg8 * reg8 -> (reg8 * flags);
	val orBits : reg8 * reg8 -> (reg8 * flags);
	val xorBits : reg8 * reg8 -> (reg8 * flags);

	val add : Bit.bit * reg8 * reg8 -> (reg8 * flags);
	val subtract : Bit.bit * reg8 * reg8 -> (reg8 * flags);
	
	val negateBits : reg8 -> (reg8 * flags);
	val u2Bits : reg8 -> (reg8 * flags);

	val compare : reg8 * reg8 -> flags;

	val rlBits : Bit.bit -> reg8 -> (reg8 * flags * Bit.bit);
	val rrBits : Bit.bit -> reg8 -> (reg8 * flags * Bit.bit);

	val rlcBits : reg8 -> (reg8 * flags * Bit.bit);
	val rrcBits : reg8 -> (reg8 * flags * Bit.bit);

	val slaBits : reg8 -> (reg8 * flags * Bit.bit);
	val sllBits : reg8 -> (reg8 * flags * Bit.bit);
	val sraBits : reg8 -> (reg8 * flags * Bit.bit);
	val srlBits : reg8 -> (reg8 * flags * Bit.bit);

	val halves : reg8 -> (Bitfield.bitfield * Bitfield.bitfield);
	val fromHalves : (Bitfield.bitfield * Bitfield.bitfield) -> reg8;

	val asString : reg8 -> string;
	val fromBitfield : Bitfield.bitfield -> reg8;
	val asBitfield : reg8 -> Bitfield.bitfield;

	val getC : flags -> Bit.bit option;
	val getP : flags -> Bit.bit option;
	val getV : flags -> Bit.bit option;
	val getH : flags -> Bit.bit option;
	val getZ : flags -> Bit.bit option;
	val getS : flags -> Bit.bit option;

end;

