signature REGISTER16 =
sig
	eqtype reg16;

	exception REGISTER16_ERROR of string;

	structure Bitfield : BITFIELD;
	structure Bit : BIT;
	sharing Bit = Bitfield.Bit;

	type flags;

	val maxSigned : int;
	val maxUnsigned : int;
	val minSigned : int;
	val minUnsigned : int;

	val setBit : int -> reg16 -> reg16;
	val resetBit : int -> reg16 -> reg16;
	val negateBit : int -> reg16 -> reg16;

	val isSet : int -> reg16 -> bool;
	val isNotSet : int -> reg16 -> bool;

	val asSigned : reg16 -> int;
	val asUnsigned : reg16 -> int;

	val fromInt : int -> reg16;
	val new : reg16;
	val zero : reg16;

	val getBit : int -> reg16 -> Bit.bit;
	val putBit : int -> Bit.bit -> reg16 -> reg16;

	val andBits : reg16 * reg16 -> (reg16 * flags);
	val orBits : reg16 * reg16 -> (reg16 * flags);
	val xorBits : reg16 * reg16 -> (reg16 * flags);

	val add : Bit.bit * reg16 * reg16 -> (reg16 * flags);
	val subtract : Bit.bit * reg16 * reg16 -> (reg16 * flags);
	
	val negateBits : reg16 -> (reg16 * flags);
	val u2Bits : reg16 -> (reg16 * flags);

	val compare : reg16 * reg16 -> flags;

	val rlBits : Bit.bit -> reg16 -> (reg16 * flags * Bit.bit);
	val rrBits : Bit.bit -> reg16 -> (reg16 * flags * Bit.bit);

	val rlcBits : reg16 -> (reg16 * flags * Bit.bit);
	val rrcBits : reg16 -> (reg16 * flags * Bit.bit);

	val slaBits : reg16 -> (reg16 * flags * Bit.bit);
	val sllBits : reg16 -> (reg16 * flags * Bit.bit);
	val sraBits : reg16 -> (reg16 * flags * Bit.bit);
	val srlBits : reg16 -> (reg16 * flags * Bit.bit);

	val halves : reg16 -> (Bitfield.bitfield * Bitfield.bitfield);
	val fromHalves : (Bitfield.bitfield * Bitfield.bitfield) -> reg16;

	val asString : reg16 -> string;
	val fromBitfield : Bitfield.bitfield -> reg16;
	val asBitfield : reg16 -> Bitfield.bitfield;

	val getC : flags -> Bit.bit option;
	val getP : flags -> Bit.bit option;
	val getV : flags -> Bit.bit option;
	val getZ : flags -> Bit.bit option;
	val getS : flags -> Bit.bit option;
end;

