functor Motherboard3 (
	structure dev1 : DEVICE; 
	structure dev2 : DEVICE; 
	structure dev3 : DEVICE; 
	structure Bus : BUS;
(*	sharing type dev1.Bus.bus_state = dev2.Bus.bus_state;
	sharing type dev2.Bus.bus_state = dev3.Bus.bus_state;
	sharing type dev3.Bus.bus_state = Bus.bus_state;
	sharing type dev1.Bus.bus_change = dev2.Bus.bus_change;
	sharing type dev2.Bus.bus_change = dev3.Bus.bus_change;
	sharing type dev3.Bus.bus_change = Bus.bus_change;
*)
	sharing dev1.Bus = Bus;
	sharing dev2.Bus = dev1.Bus;
	sharing dev3.Bus = dev2.Bus;
	
	) =
struct
	structure Bus = Bus;
	structure Dev2 = dev2;
	type mb_state = (
		Bus.bus_state *
		dev1.device_state * 
		dev2.device_state * 
		dev3.device_state
	);
	val initial_state : mb_state =  (
		Bus.initial_state,
		dev1.initial_state,
		dev2.initial_state, 
		dev3.initial_state
	);
	exception BUS_CONFLICT of Bus.bus_change;
	fun tick ((bstate, d1, d2, d3) : mb_state) : mb_state = 
		let
(*			val d1 = #1 state;
			val d2 = #2 state;
			val d3 = #3 state;
			val bstate = #4 state;
*)			val (b1, d1')  = dev1.tick (bstate, d1);
			val (b2, d2')  = dev2.tick (bstate, d2);
			val (b3, d3')  = dev3.tick (bstate, d3);
			val l = [b1, b2, b3];
			val (newbus, err) = Bus.checkSignalConflict (l, bstate);
		in
			if isSome(err) then
				raise BUS_CONFLICT(valOf(err))
			else
				(newbus, d1', d2', d3')
		end
	;
	fun asString ((bstate, d1, d2, d3) : mb_state) = 
		"DEV1:" ^ (dev1.asString d1) ^
		"BUS:" ^ (Bus.asString bstate) ^
		"DEV2:" ^ (dev2.asString d2) ^
		"DEV3:" ^ (dev3.asString d3) ^
		"\n"
	;
end;
