signature CPU_Z80 =
sig
	structure Register8 : REGISTER8;
	structure Register16 : REGISTER16;
	structure Bus : BUS_Z80;
	structure Bitfield : BITFIELD;
	structure Bit : BIT;
	sharing Register8 = Bus.Register8;
	sharing Register16 = Bus.Register16;
	sharing Bit = Bus.Bit;
	sharing Bitfield = Bus.Bitfield;

	type device_state;
	val initial_state : device_state;
	val tick : (Bus.bus_state * device_state) -> (Bus.bus_change * device_state);
	val asString : device_state -> string;

	val readStream : BinIO.instream -> device_state;
end;