signature BUS_Z80 =
sig
	structure Bitfield : BITFIELD;
	structure Bit : BIT;
	sharing Bit = Bitfield.Bit;
	structure Register8 : REGISTER8;
	structure Register16 : REGISTER16;
	sharing Register8.Bitfield = Register16.Bitfield;
	sharing Register16.Bitfield = Bitfield;
	datatype cycle_state = ASCENDING | HIGH | DESCENDING | LOW;
	type bus_state;
	type bus_change;
	val next_cycle_state : cycle_state -> cycle_state;
	val initial_state : bus_state;
	val no_signals_state : bus_state;
	val no_bus_change : bus_change;
	val checkSignalConflict : bus_change list * bus_state -> (bus_state * (bus_change option));

	val putM1 : Bit.bit -> bus_change -> bus_change;
	val setM1bool : bool -> bus_change -> bus_change;
	val setM1 : bus_change -> bus_change;
	val resetM1 : bus_change -> bus_change;
	val getM1 : bus_state -> Bit.bit;
	val isSetM1 : bus_state -> bool;
	val isNotSetM1 : bus_state -> bool;

	val putMREQ : Bit.bit -> bus_change -> bus_change;
	val setMREQbool : bool -> bus_change -> bus_change;
	val setMREQ : bus_change -> bus_change;
	val resetMREQ : bus_change -> bus_change;
	val getMREQ : bus_state -> Bit.bit;
	val isSetMREQ : bus_state -> bool;
	val isNotSetMREQ : bus_state -> bool;

	val putIORQ : Bit.bit -> bus_change -> bus_change;
	val setIORQbool : bool -> bus_change -> bus_change;
	val setIORQ : bus_change -> bus_change;
	val resetIORQ : bus_change -> bus_change;
	val getIORQ : bus_state -> Bit.bit;
	val isSetIORQ : bus_state -> bool;
	val isNotSetIORQ : bus_state -> bool;

	val putRD : Bit.bit -> bus_change -> bus_change;
	val setRDbool : bool -> bus_change -> bus_change;
	val setRD : bus_change -> bus_change;
	val resetRD : bus_change -> bus_change;
	val getRD : bus_state -> Bit.bit;
	val isSetRD : bus_state -> bool;
	val isNotSetRD : bus_state -> bool;

	val putWR : Bit.bit -> bus_change -> bus_change;
	val setWRbool : bool -> bus_change -> bus_change;
	val setWR : bus_change -> bus_change;
	val resetWR : bus_change -> bus_change;
	val getWR : bus_state -> Bit.bit;
	val isSetWR : bus_state -> bool;
	val isNotSetWR : bus_state -> bool;

	val putRFSH : Bit.bit -> bus_change -> bus_change;
	val setRFSHbool : bool -> bus_change -> bus_change;
	val setRFSH : bus_change -> bus_change;
	val resetRFSH : bus_change -> bus_change;
	val getRFSH : bus_state -> Bit.bit;
	val isSetRFSH : bus_state -> bool;
	val isNotSetRFSH : bus_state -> bool;

	val putHALT : Bit.bit -> bus_change -> bus_change;
	val setHALTbool : bool -> bus_change -> bus_change;
	val setHALT : bus_change -> bus_change;
	val resetHALT : bus_change -> bus_change;
	val getHALT : bus_state -> Bit.bit;
	val isSetHALT : bus_state -> bool;
	val isNotSetHALT : bus_state -> bool;

	val putWAIT : Bit.bit -> bus_change -> bus_change;
	val setWAITbool : bool -> bus_change -> bus_change;
	val setWAIT : bus_change -> bus_change;
	val resetWAIT : bus_change -> bus_change;
	val getWAIT : bus_state -> Bit.bit;
	val isSetWAIT : bus_state -> bool;
	val isNotSetWAIT : bus_state -> bool;

	val putRESET : Bit.bit -> bus_change -> bus_change;
	val setRESETbool : bool -> bus_change -> bus_change;
	val setRESET : bus_change -> bus_change;
	val resetRESET : bus_change -> bus_change;
	val getRESET : bus_state -> Bit.bit;
	val isSetRESET : bus_state -> bool;
	val isNotSetRESET : bus_state -> bool;

	val putINT : Bit.bit -> bus_change -> bus_change;
	val setINTbool : bool -> bus_change -> bus_change;
	val setINT : bus_change -> bus_change;
	val resetINT : bus_change -> bus_change;
	val getINT : bus_state -> Bit.bit;
	val isSetINT : bus_state -> bool;
	val isNotSetINT : bus_state -> bool;

	val putNMI : Bit.bit -> bus_change -> bus_change;
	val setNMIbool : bool -> bus_change -> bus_change;
	val setNMI : bus_change -> bus_change;
	val resetNMI : bus_change -> bus_change;
	val getNMI : bus_state -> Bit.bit;
	val isSetNMI : bus_state -> bool;
	val isNotSetNMI : bus_state -> bool;

	val putBUSRQ : Bit.bit -> bus_change -> bus_change;
	val setBUSRQbool : bool -> bus_change -> bus_change;
	val setBUSRQ : bus_change -> bus_change;
	val resetBUSRQ : bus_change -> bus_change;
	val getBUSRQ : bus_state -> Bit.bit;
	val isSetBUSRQ : bus_state -> bool;
	val isNotSetBUSRQ : bus_state -> bool;

	val putBUSAK : Bit.bit -> bus_change -> bus_change;
	val setBUSAKbool : bool -> bus_change -> bus_change;
	val setBUSAK : bus_change -> bus_change;
	val resetBUSAK : bus_change -> bus_change;
	val getBUSAK : bus_state -> Bit.bit;
	val isSetBUSAK : bus_state -> bool;
	val isNotSetBUSAK : bus_state -> bool;

	val putAddress : Register16.reg16 -> bus_change -> bus_change;
	val getAddress : bus_state -> Register16.reg16;

	val putData : Register8.reg8 -> bus_change -> bus_change;
	val getData : bus_state -> Register8.reg8;
	val getCycle : bus_state -> cycle_state;

	val asString : bus_state -> string;
end;
