signature BITFIELD =
sig
	eqtype bitfield;
	structure Bit : BIT;
	exception BITFIELD_ERROR of string;

	val maxWidth : int option;

	val new : int -> bitfield;
	val fromInt : int -> int -> bitfield;
	val fromBit : Bit.bit -> bitfield;

	val width : bitfield -> int;

	val maxSigned : bitfield -> int;
	val maxUnsigned : bitfield -> int;
	val minSigned : bitfield -> int;
	val minUnsigned : bitfield -> int;

	val setBit : int -> bitfield -> bitfield;
	val resetBit : int -> bitfield -> bitfield;
	val negateBit : int -> bitfield -> bitfield;

	val isSet : int -> bitfield -> bool;
	val isNotSet : int -> bitfield -> bool;

	val asSigned : bitfield -> int;
	val asUnsigned : bitfield -> int;

	val getBit : int -> bitfield -> Bit.bit;
	val putBit : int -> Bit.bit -> bitfield -> bitfield;

	val andBits : bitfield * bitfield -> bitfield;
	val orBits : bitfield * bitfield -> bitfield;
	val xorBits : bitfield * bitfield -> bitfield;

	val negateBits : bitfield -> bitfield;
	val u2Bits : bitfield -> bitfield;

	val rorBits : int -> bitfield -> bitfield;
	val rolBits : int -> bitfield -> bitfield;

	val addBits : Bit.bit * bitfield * bitfield -> (bitfield * bitfield); (* bf * carries *)
	val subtractBits : Bit.bit * bitfield * bitfield -> (bitfield * bitfield); (* bf * borrows *)
	val countOnes : bitfield -> int;

	val subField : int -> int -> bitfield ->bitfield;
	val append : bitfield * bitfield -> bitfield;
	
	val asString : bitfield -> string;
end;

