signature BIT = 
sig
	datatype bit = ZERO | ONE;
	val zero : bit;
	val one : bit;
	val negate : bit -> bit;
	val isSet : bit -> bool;
	val isNotSet : bit -> bool;
	val fromInt : int -> bit;
	val fromBool : bool -> bit;
	val asInt : bit -> int;
	val asBool : bit -> bool;
	val andBits : bit * bit -> bit;
	val orBits : bit * bit -> bit;
	val xorBits : bit * bit -> bit;
	val addWithCarry : bit * bit * bit -> bit * bit;
	val subtractWithBorrow : bit * bit * bit -> bit * bit;
	val asString : bit -> string;
(*EML-B
	axiom negate ZERO = ONE
	    | negate ONE = ZERO
	;
	axiom forall (x : bit) => if isSet x then x = ONE else x=ZERO
	;
	axiom zero = ZERO;
	axiom one = ONE;
	axiom forall (x : bit) => isSet x = not (isNotSet x)
	;
	axiom andBits (ZERO, ZERO) = ZERO
	    | andBits (ZERO, ONE) = ZERO
	    | andBits (ONE, ZERO) = ZERO
	    | andBits (ONE, ONE) = ONE
	;
	axiom orBits (ZERO, ZERO) = ZERO
	    | orBits (ZERO, ONE) = ONE
	    | orBits (ONE, ZERO) = ONE
	    | orBits (ONE, ONE) = ONE
	;
	axiom xorBits (ZERO, ZERO) = ZERO
	    | xorBits (ZERO, ONE) = ONE
	    | xorBits (ONE, ZERO) = ONE
	    | xorBits (ONE, ONE) = ZERO
	;
	axiom addWithCarry (ZERO, ZERO, ZERO) = (ZERO, ZERO)
	    | addWithCarry (ZERO, ZERO, ONE) = (ONE, ZERO)
	    | addWithCarry (ZERO, ONE, ZERO) = (ONE, ZERO)	
	    | addWithCarry (ZERO, ONE, ONE) = (ZERO, ONE)
	    | addWithCarry (ONE, ZERO, ZERO) = (ONE, ZERO)
	    | addWithCarry (ONE, ZERO, ONE) = (ZERO, ONE)
	    | addWithCarry (ONE, ONE, ZERO) = (ZERO, ONE)
	    | addWithCarry (ONE, ONE, ONE) = (ONE, ONE)
	;
EML-E*)
end;
