fun intPadded n i = StringCvt.padLeft (valOf(Char.fromString " ")) n (Int.toString i)
;

val asHex =  Int.fmt StringCvt.HEX;
fun fromHex (s:string) = 
	let
		val e = explode s;
		fun f acc [] = acc
		  | f acc (a::tl) = 
			let 
				fun c "0" = 0
				  | c "1" = 1
				  | c "2" = 2
				  | c "3" = 3
				  | c "4" = 4
				  | c "5" = 5
				  | c "6" = 6
				  | c "7" = 7
				  | c "8" = 8
				  | c "9" = 9
				  | c "a" = 10
				  | c "b" = 11
				  | c "c" = 12
				  | c "d" = 13
				  | c "e" = 14
				  | c "f" = 15
				  | c _ = raise Fail("Trying to convert non-hexadecimal number")
				;
			in
				f (acc*16 + (c (Char.toString a))) tl
			end
		
	in
		f 0 e
	end
;
