/*
 * Copyright (c) 2015, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */


package org.graalvm.compiler.jtt.bytecode;

import org.junit.Test;

import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.jtt.JTTTest;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.Suites;

/**
 * Tests the instanceof works, when casting an array of interface.
 */
public class BC_instanceof01 extends JTTTest {

    public interface IObject {

    }

    public interface IDerivedObject extends IObject {

    }

    private static class BaseClass {

    }

    private static class TestClass extends BaseClass implements IObject {
    }

    private static class DerivedTestClass extends BaseClass implements IDerivedObject {

    }

    static TestClass[] a1 = {new TestClass()};
    static DerivedTestClass[] a2 = {new DerivedTestClass()};

    public static BaseClass[] getBaseClassArray() {
        return a1;
    }

    public static BaseClass[] getDerivedBaseClassArray() {
        return a2;
    }

    public static boolean test() {
        return getBaseClassArray() instanceof IObject[];
    }

    public static int testConditionalElimination() {
        BaseClass[] result = getDerivedBaseClassArray();
        if (result instanceof IDerivedObject[]) {
            if (result instanceof IObject[]) {
                return 1;
            } else {
                return 2;
            }
        } else {
            return 3;
        }
    }

    @Test
    public void run0() throws Throwable {
        runTest("test");
    }

    @Override
    @SuppressWarnings("try")
    protected Suites createSuites(OptionValues options) {
        return super.createSuites(new OptionValues(options, HighTier.Options.Inline, false));
    }

    @Test
    public void run1() throws Throwable {
        runTest("testConditionalElimination");
    }
}
