/*
  This file is a part of the nesccov extensions to the nesc compiler.

  Copyright(c) 2011-2014 University of Warsaw. All rights reserved.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

    * Redistributions of source code must retain the above copyright 
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright 
      notice, this list of conditions and the following disclaimer in 
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of University of Warsaw nor the names of its 
      contributors may be used to endorse or promote products derived 
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __NESCCOV_TOS_H__
#define __NESCCOV_TOS_H__

#include <nesccov-runtime.h>



/**
 * @file TinyOS support for nesccov.
 */

unsigned char   TM_CODE_ARRAY_NAME[1];
unsigned int    TM_CODE_ARRAY_SIZE = 1;

unsigned char   TM_COND_ARRAY_NAME[1];
unsigned int    TM_COND_ARRAY_SIZE = 1;



#define SET_BIT_8(where, which) \
  (where) |= ((unsigned char)(1<<7))>>(which)

#define UNSET_BIT_8(where, which) \
  (where) &= ~(((unsigned char)(1<<7))>>(which))


#define FINISHED(ptr,atoms_no) (!((ptr)<(atoms_no)))

#define GET_BIT_8(where, which) \
  ((where)&(((unsigned char)(1<<7))>>(which)))
  
#define STATE_TO_NUMBER(state, atoms_q) \
  ((state)>>(8-(atoms_q)))

unsigned char TM_FNAME_EXP_FUNC(unsigned char cond,
				unsigned short counter,
				unsigned char *state,
				unsigned char *state_bis) __attribute__((C, spontaneous))
{
  if(counter==0){
    *state &= (unsigned char)0;
    *state_bis &= (unsigned char)0;
  }

  if(cond)
    SET_BIT_8(*state, counter);
  
  SET_BIT_8(*state_bis, counter);
  return cond;
}

static void __nesccov_write_state(unsigned char state, unsigned short offset, unsigned short atoms_no)
{
  unsigned int tmp =  offset + (STATE_TO_NUMBER(state,atoms_no));
  SET_BIT_8(*(TM_COND_ARRAY_NAME + tmp/8), tmp%8);
}

static void __nesccov_helper(unsigned char ptr,
		   unsigned char state,
		   unsigned char state_bis,
		   unsigned short offset,
		   unsigned short atoms_no)
{
 
  if(FINISHED(ptr,atoms_no)){
    __nesccov_write_state(state, offset, atoms_no);
  } else{
    if(!GET_BIT_8(state_bis, ptr)){
      SET_BIT_8(state, ptr);
      __nesccov_helper(ptr+1, state, state_bis, offset, atoms_no);
      UNSET_BIT_8(state, ptr);
      __nesccov_helper(ptr+1, state, state_bis, offset, atoms_no);
    } else{
      __nesccov_helper(ptr+1, state, state_bis, offset, atoms_no);
    }
  }
}

void TM_FNAME_EXP_FIN_FUNC(unsigned short offset,
			   unsigned short atoms_no,
			   unsigned char *state,
			   unsigned char *state_bis) __attribute__((C, spontaneous))
{
  __nesccov_helper(0, *state, *state_bis, offset, atoms_no);
}

#endif /* __NESCCOV_TOS_H__ */

