/*
  This file is a part of the nesccov extensions to the nesc compiler.

  Copyright(c) 2011-2014 University of Warsaw. All rights reserved.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

    * Redistributions of source code must retain the above copyright 
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright 
      notice, this list of conditions and the following disclaimer in 
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of University of Warsaw nor the names of its 
      contributors may be used to endorse or promote products derived 
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/**
 * A decorator for the dumper for the nesccov coverage information.
 *
 * @author Karol Strzelecki <ks249241@students.mimuw.edu.pl>
 * @author Konrad Iwanicki <iwanicki@mimuw.edu.pl>
 */
module NescCovInfoDumpDecoratorP
{
    provides
    {
        interface NescCovInfoDumper;
    }
    uses
    {
        interface Timer<TMilli> as LineCoverageTimer;
        interface Timer<TMilli> as CondCoverageTimer;
        interface NescCovInfoDump as LineCoverageDump;
        interface NescCovInfoDump as CondCoverageDump;
    }
}
implementation
{

    command void NescCovInfoDumper.setInterval(uint32_t mills)
    {
        call LineCoverageTimer.startPeriodic(mills);
        call CondCoverageTimer.startPeriodic(mills);
    }

    event void LineCoverageTimer.fired()
    {
        call LineCoverageDump.startDump();
    }
  
    event void CondCoverageTimer.fired()
    {
        call CondCoverageDump.startDump();
    }

    event void LineCoverageDump.dumpDone(error_t err) {}

    event void CondCoverageDump.dumpDone(error_t err) {}

    command void NescCovInfoDumper.dumpOneTime(){
        call LineCoverageDump.startDump();
        call CondCoverageDump.startDump();
    }

}

