/*
  This file is a part of the nesccov extensions to the nesc compiler.

  Copyright(c) 2011-2014 University of Warsaw. All rights reserved.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

    * Redistributions of source code must retain the above copyright 
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright 
      notice, this list of conditions and the following disclaimer in 
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of University of Warsaw nor the names of its 
      contributors may be used to endorse or promote products derived 
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <nesccov-runtime.h>
#include <nesccov-tos.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


#ifndef TOSSIM
#error This component works only in TOSSIM!
#endif

#ifndef NESCCOV_COND_COVERAGE
#error NescCov condition coverage not activated!
#endif


/**
 * A dumper of condition coverage information for nesccov that
 * works in TOSSIM.
 *
 * @author Karol Strzelecki <ks249241@students.mimuw.edu.pl>
 * @author Konrad Iwanicki <iwanicki@mimuw.edu.pl>
 */
module NescCovCondInfoTossimDumpC @safe()
{
    provides
    {
        interface NescCovInfoDump as Dump;
    }
}
implementation
{

    char const * const   fil_name = "nesccov_cond.exec";
    int                  fil_exec;

    task void dumpStep();

    command error_t Dump.startDump()
    {
        fil_exec = open(fil_name, O_RDWR|O_CREAT|O_TRUNC, 0644);

        if(!fil_exec)
        {
            fprintf(stderr, "error wile opening file");
            return FAIL;
        }
        post dumpStep();
        return SUCCESS;
    }

    task void dumpStep()
    {
        char const * err = NULL;
        int32_t ar_sz = TM_CODE_ARRAY_SIZE;

        if (write(fil_exec, (void*)&ar_sz, sizeof(uint32_t)) < sizeof(uint32_t))
        {
            err = "error while writing header";
            goto cleanup;
        }
        if (write(fil_exec, (void*)TM_COND_ARRAY_NAME, TM_COND_ARRAY_SIZE) < TM_COND_ARRAY_SIZE)
        {
            err = "error while writing data";
            goto cleanup;
        }

    cleanup:
        close(fil_exec);
        if (err != NULL)
        {
            fprintf(stderr, "ERROR (file %s): %s!\n", fil_name, err);
            signal Dump.dumpDone(FAIL);
        }
        else
        {
            signal Dump.dumpDone(SUCCESS);
        }
    }
}

