#ifndef WeaponModel_hpp
#define WeaponModel_hpp

#include <QtWidgets>
#include "Serial.hpp"

/**
 * WeaponModel
 * - Qstring name
 * - int damage
 * - enum Handedness
 * - enum WeaponType
 * - enum DamageType
 * - int durability
 * - int weight
 */

class Weapon {
	friend QDataStream & operator <<(QDataStream &out, const Weapon &weapon);
	friend QDataStream & operator >>(QDataStream &in, Weapon &weapon);
public:
	enum class Handedness {
		OneHanded,
		TwoHanded
	};

	enum class WeaponType : quint8 {
		Sword,
		Mace,
		Bow,
		Axe,
		Crossbow
	};

	enum class DamageType {
		Slash,
		Bludgeon,
		Pierce,
		Magic
	};

	Weapon(UID uid = Serial::EmptyUid);

	QString name() const {return name_;}
	void setName(QString name) {name_ = name;}

	WeaponType weaponType() const {return weaponType_;}
	void setWeaponType(WeaponType weaponType) {weaponType_ = weaponType;}

	int damage() const {return damage_;}
	void setDamage(int damage) {damage_ = damage;}

	int weight() const {return weight_;}
	void setWeight(int weight) {weight_ = weight;}

	QString weaponTypeName() const;

	UID uid() const {return uid_;}

private:
	UID uid_;
	QString name_;
	WeaponType weaponType_;
	int damage_;
	int weight_;

};

QDataStream & operator <<(QDataStream &out, const Weapon &weapon);
QDataStream & operator >>(QDataStream &in, Weapon &weapon);

class WeaponModel : public QAbstractTableModel {
	Q_OBJECT;
	friend QDataStream & operator <<(QDataStream &out, const WeaponModel &wModel);

public:
	WeaponModel(QObject *parent = nullptr);

	int columnCount(const QModelIndex & = QModelIndex()) const;
	int rowCount(const QModelIndex & = QModelIndex()) const;

	QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
	bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole);
	QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
	Qt::ItemFlags flags(const QModelIndex & = QModelIndex()) const;

	bool insertRows(int row, int count, const QModelIndex &parent = QModelIndex());
	bool removeRows(int row, int count, const QModelIndex &parent = QModelIndex());

	static const int Name = 0;
	static const int WeaponType = 1;
	static const int Damage = 2;
	static const int Weight = 3;
	static const int ColumnCount = 4;

private:
	Serial serial_;
	QVector <Weapon> weaponData;
};

QDataStream & operator <<(QDataStream &out, const WeaponModel &wModel);
QDataStream & operator >>(QDataStream &in, WeaponModel &wModel);

#endif
