#ifndef SERIAL_HPP
#define SERIAL_HPP

typedef quint32 UID;

class Serial {
	friend QDataStream & operator<<(QDataStream &stream, const Serial &serial);
	friend QDataStream & operator>>(QDataStream &stream, Serial &serial);
public:
	static const UID EmptyUid = 0;
	static const UID MinUid = 1;

	Serial() : nextUid(MinUid) {}
	UID next() { return nextUid++; }

private:
	UID nextUid;
};

/*
 * Operators
 */

inline QDataStream & operator<<(QDataStream &stream, const Serial &serial)
{
	stream << serial.nextUid;
	return stream;
}

inline QDataStream & operator>>(QDataStream &stream, Serial &serial)
{
	stream >> serial.nextUid;
	return stream;
}

#endif
