#include "MainWindow.hpp"
#include "WeaponModel.hpp"

MainWindow::MainWindow(QWidget *parent)
	: QMainWindow(parent)
{
	resize(800, 600);

	view = new QTableView;
	model = new WeaponModel(this);
	view->setModel(model);
	view->setSelectionBehavior(QAbstractItemView::SelectRows);
	view->setSelectionMode(QAbstractItemView::SingleSelection);

	nameEdit = new QLineEdit;

	QPushButton *addWeapon = new QPushButton("Add weapon");
	connect(addWeapon, &QPushButton::clicked, this, &MainWindow::addDefaultWeapon);

	QPushButton *removeWeapon = new QPushButton("Remove weapon");
	connect(removeWeapon, &QPushButton::clicked, this, &MainWindow::removeWeapon);

	QVBoxLayout *layout = new QVBoxLayout;
	layout->addWidget(view);
	layout->addWidget(nameEdit);
	layout->addWidget(addWeapon);
	layout->addWidget(removeWeapon);

	QWidget *placeholder = new QWidget;
	placeholder->setLayout(layout);
	setCentralWidget(placeholder);

	mapper = new QDataWidgetMapper(this);
	mapper->setModel(model);
	mapper->addMapping(nameEdit, WeaponModel::Name);
	mapper->setSubmitPolicy(QDataWidgetMapper::AutoSubmit);
	connect(view->selectionModel(), &QItemSelectionModel::currentRowChanged, mapper, &QDataWidgetMapper::setCurrentModelIndex);
}

void MainWindow::addDefaultWeapon()
{
	model->insertRows(0, 1);
}

void MainWindow::removeWeapon()
{
	QModelIndex selected = view->selectionModel()->currentIndex();
	if (!selected.isValid())
		return;
	model->removeRows(selected.row(), 1);
}
