#include <stdio.h>

/*@ predicate posortowane{L}(int* t, int od, int doo) =
      \forall integer i, j;  od <= i <= j < doo ==> t[i] <= t[j];
@*/


/*@ requires n>0 && \valid(t+(0..n-1));
  @ ensures posortowane(t,0,n);
  @*/
void insert_sort(int t[], int n) {
  int i,j;
  int mv;
  if (n <= 1) return;
  //@ invariant posortowane(t, 0, i);
  //@ invariant 1 <= i <= n;
  // ciąg elementów t[0..i-1] jest posortowany
  for (i=1; i<n; i++) {
    mv = t[i]; 
    // elementy t[j..i] są większe od mv
    for (j=i; j > 0; j--) {
      if (t[j-1] <= mv) break;
      t[j] = t[j-1];
    }
    t[j] = mv;
  }
}

void show(int t[], int n) {
  int i = 0;
  for (i=0; i<n; i++) {
     printf( "%d, ", t[i]);
  };
  printf( "\n");
}

int main() {

  int t1[] = {1, 3, 6};
  show(t1, 3);
  insert_sort(t1, 3);
  show(t1, 3);
  

  int t2[] = {6, 3, 7};
  show(t2, 3);
  insert_sort(t2, 3);
  show(t2, 3);


  int t3[] = {1, 3, 6, 2};
  show(t3, 4);
  insert_sort(t3, 4);
  show(t3, 4);
}
