/*@ predicate posortowane{L}(int *a, integer l, integer h) =
  @   \forall integer i,j; l <= i <= j < h ==> a[i] <= a[j] ;
  @*/

/*@ requires n>0 && \valid(t+(0..n-1));
  @ ensures posortowane(t,0,n);
  @*/
void insert_sort(int t[], int n) {
  int i,j;
  int mv;
  if (n <= 1) return;
  // ciąg elementów t[0..i-1] jest posortowany
  /*@ loop invariant 0 <= i <= n && i >0;
    @ loop invariant posortowane(t,0,i);
    @ loop assigns i, j, mv, t[0..n-1];
    @ loop variant n-i;
    @*/
  for (i=1; i<n; i++) {
    mv = t[i]; 
    /*@ loop invariant 0 <= j <= i && i > 0;
      @ loop invariant j == i ==> posortowane(t,0,i);
      @ loop invariant j < i ==> posortowane(t,0,i+1);
      @ loop invariant \forall integer k; j <= k <= i ==> t[k] >= mv;
      @ loop assigns j, t[0..i];
      @ loop variant j;
      @*/
    // ciąg elementów t[0..i-1] jest posortowany
    // elementy t[j..i] są większe od mv
    for (j=i; j > 0; j--) {
      if (t[j-1] <= mv) break;
      t[j] = t[j-1];
    }
    // @ assert \forall integer k; 0 <= k <= j-1 ==> t[k] <= mv;
    t[j] = mv;
    //@ assert posortowane(t, 0, j-1);
    //@ assert posortowane(t, j+1, i+1);
  }
}


/*
Local Variables:
compile-command: "frama-c -jessie insertion_sort.c"
End:
*/
