#include <sys/syscall.h>
#include "esyscall.h"

#include "supervisor.h"

short syscall_flags[MAX_SYSNR] = {
    [__NR_restart_syscall] = SC_ALLOWED,
    [__NR_read]            = SC_ALLOWED|SC_NOEXTENSION,
    [__NR_readv]           = SC_ALLOWED|SC_NOEXTENSION,
    [__NR_readlink]        = SC_ALLOWED,
    [__NR_write]           = SC_ALLOWED|SC_NOEXTENSION,
    [__NR_writev]          = SC_ALLOWED|SC_NOEXTENSION,
    [__NR_stat]            = SC_ALLOWED,
    [__NR_stat64]          = SC_ALLOWED,
    [__NR_fstat]           = SC_ALLOWED,
    [__NR_fstat64]         = SC_ALLOWED,
    [__NR_access]          = SC_ALLOWED,
    [__NR_mmap]            = SC_ALLOWED|SC_MEMORY|SC_NOEXTENSION,
    [__NR_mmap2]           = SC_ALLOWED|SC_MEMORY|SC_NOEXTENSION,
    [__NR_munmap]          = SC_ALLOWED|SC_MEMORY|SC_NOEXTENSION,
    [__NR_mremap]          = SC_ALLOWED|SC_MEMORY|SC_NOEXTENSION,
    [__NR_time]            = SC_ALLOWED,
    [__NR_close]           = SC_ALLOWED,
    [__NR_brk]             = SC_ALLOWED|SC_MEMORY,
    [__NR_exit]            = SC_ALLOWED,
    [__NR_exit_group]      = SC_ALLOWED,

    [__NR_uname]           = SC_ALLOWED,
    [__NR_mprotect]        = SC_ALLOWED,
    [__NR_set_thread_area] = SC_ALLOWED,
    [__NR_getpid]          = SC_ALLOWED,
    [__NR_gettid]          = SC_ALLOWED,
    [__NR_open]            = SC_ALLOWED, /* handled by quirk_open */
    [__NR_kill]            = SC_ALLOWED, /* handled by quirk_syscall */
    [__NR_tkill]           = SC_ALLOWED, /* handled by quirk_syscall */
    [__NR_tgkill]          = SC_ALLOWED, /* handled by quirk_syscall */

    [__NR_sigaction]       = SC_SKIP,
    [__NR_sigaltstack]     = SC_SKIP,
    [__NR_rt_sigprocmask]  = SC_SKIP,
    [__NR_rt_sigaction]    = SC_SKIP,
    [__NR_fcntl]           = SC_SKIP,
    [__NR_fcntl64]         = SC_SKIP,
    [__NR_ioctl]           = SC_SKIP,
    [__NR__llseek]         = SC_SKIP,
    [__NR_ugetrlimit]      = SC_SKIP,
    [__NR_getrlimit]       = SC_SKIP,

    [__NRe_ioshmget]       = SC_EXTENSION,
    [__NRe_ioshmat]        = SC_EXTENSION,
    [__NRe_iochunk]        = SC_EXTENSION,
};

const char* allowed_open_dirs[] = {
    "/lib/",
    "/usr/lib/",
    "/etc/ld.so",
    "/proc",
    "/etc/timezone",
    NULL
};
