#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

extern char** U_SYSLINUX_ENVP;
extern char** U_SYSLINUX_ARGV;

static char* svpath[] = {
    "/usr/bin/supervisor",
    "/usr/local/bin/supervisor",
    "./supervisor",
    "../supervisor",
    NULL
};

void svioloader_run(void)
{
    char* args[30];
    char* env[1];
    char** a = args;
    int fd;
    char buf[65536];
    char* bc = buf;
    char* cc = buf;

    env[0] = NULL;

    fd = open("/proc/self/cmdline", O_RDONLY, 0);
    if (fd < 0)
    {
        fprintf(stderr, "libsvloader: cannot open /proc/self/cmdline,\n"
                        "             falling back to standalone mode.\n");
        return;
    }

    for (;;) {
        ssize_t r = read(fd, bc, buf + sizeof(buf) - bc);
        if (r == 0)
            break;
        if (r < 0)
        {
            fprintf(stderr, "libsvloader: error reading /proc/self/cmdline,\n"
                            "             falling back to standalone mode.\n");
            return;
        }
        bc += r;
    }

    *(a++) = "supervisor";
    *(a++) = "-e";
    *(a++) = "-r";
    *(a++) = "-q";

    while (cc < bc) {
        *(a++) = cc;
        while (*(++cc));
    }
    *a = NULL;

    a = svpath;
    while (*a) {
        execve(*a, args, env);
        a++;
    }

    fprintf(stderr, "libsvloader: cannot run supervisor, falling back \n"
                    "             to standalone mode.\n");
}
