#include "svio.h"

extern void* __svio_ocursor;
extern void* __svio_olimit;

extern void __svio_flush(void);

static inline void check_space(int len)
{
    if (__svio_ocursor + len > __svio_olimit)
        __svio_flush();
}

static inline void write_sig(char sig)
{
    *(char*)__svio_ocursor++ = sig;
}


void write_int(int v)
{
    write_ulonglong(v);
}

void write_uint(unsigned int v)
{
    write_ulonglong(v);
}

void write_longlong(long long v)
{
    write_ulonglong(v);
}

void write_ulonglong(unsigned long long v)
{
    check_space(9);
    write_sig('N');
    *(long long*)__svio_ocursor = v;
    __svio_ocursor += 8;
}

void write_string(const char* s)
{
    unsigned long* lenptr;
    const char* beg;

    do {
        beg = s;
        check_space(5);
        write_sig('S');
        lenptr = (unsigned long*)__svio_ocursor;
        __svio_ocursor += 4;
        while (__svio_ocursor < __svio_olimit && *s != '\0')
            *(char*)(__svio_ocursor++) = *(s++);
        *lenptr = s - beg;
    } while (*s != '\0');
}

void write_char(char c)
{
    check_space(2);
    write_sig('C');
    *(char*)__svio_ocursor++ = c;
}

void write_newline(void)
{
    write_char('\n');
}

