#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <esyscall.h>
#include <ioshm.h>
#include <errno.h>

#include <unistd.h>
#include <linux/unistd.h>

#include "svio.h"
#include "emu.h"
#include "syscall.h"

struct ioshm_hdr* __svio_hdr;
void* __svio_ioshm;
void* __svio_icursor;
void* __svio_iend;
void* __svio_obegin;
void* __svio_ocursor;
void* __svio_olimit;

static int emu_active;

_syscall4(int, ioshmget, int, foo1, int, foo2, int, foo3, int, foo4);
_syscall5(int, ioshmat, void**, addr, int, foo2, int, foo3, int, foo4,
        int, foo5);
_syscall0(int, ioflush);
_syscall0(int, iochunk);
_syscall0(int, svtest);

static void svio_err(const char* msg)
{
    fprintf(stderr, "libsvio error: ");
    fprintf(stderr, msg);
    fprintf(stderr, "\n");
    exit(121);
}

void __attribute__((constructor)) __svio_init(void)
{
    int res;

#ifdef SVIO_WITH_LOADER
    if (svtest() < 0) {
        extern void svioloader_run(void);
        svioloader_run();
    }
#endif
    
    res = ioshmget(0, 0, 0, 0);
    if (res < 0)
    {
        int err = errno;
#ifdef SVIO_WITH_EMU
        if (err == ENOSYS) {
            fprintf(stderr, "libsvio: using emulation\n");
            emu_active = 1;
            __svio_init_emu();
            return;
        }
#endif
        svio_err("e_ioshmget failed");
    }
    res = ioshmat(&__svio_ioshm, 0, 0, 0, 0);
    if (res < 0)
        svio_err("e_ioshmat failed");

    __svio_hdr = (struct ioshm_hdr*)__svio_ioshm;
    if (memcmp(__svio_hdr->magic, "IOSHM", 5))
        svio_err("invalid ioshm signature");

    __svio_obegin = __svio_ioshm + __svio_hdr->odata_offset;
    __svio_olimit = __svio_obegin + __svio_hdr->odata_bufsize;
    __svio_ocursor = __svio_obegin;
}

void __svio_refill(void)
{
#ifdef SVIO_WITH_EMU
    if (emu_active) {
        __svio_refill_emu();
        return;
    }
#endif

    iochunk();
    __svio_icursor = __svio_ioshm + __svio_hdr->idata_offset;
    __svio_iend = __svio_icursor + __svio_hdr->idata_bufsize;
}

void __svio_flush(void)
{
#ifdef SVIO_WITH_EMU
    if (emu_active) {
        __svio_flush_emu();
        return;
    }
#endif

    __svio_hdr->odata_bufsize = __svio_ocursor - __svio_obegin;
    ioflush();
    __svio_ocursor = __svio_obegin;
}

void svio_flush()
{
    __svio_flush();
}

void __svio_formaterror(void)
{
    fprintf(stderr, "libsvio: data format mismatch");
    exit(120);
}

void __attribute__((destructor)) __svio_exit(void)
{
    if (__svio_ioshm == NULL)
        return;

    __svio_flush();
}

