#include <stdlib.h>
#include <unistd.h>
#include <linux/unistd.h>

#include "../libsvioparse/svioparse.h"

#include "svio.h"
#include "ioshm.h"

#define SVIO_SIZE    65536
#define SVIO_OOFFSET 32768

extern struct ioshm_hdr* __svio_hdr;
extern char* __svio_ioshm;
extern void* __svio_icursor;
extern void* __svio_iend;
extern void* __svio_obegin;
extern void* __svio_ocursor;
extern void* __svio_olimit;

char  __svio_ioshm_emu[SVIO_SIZE + sizeof(*__svio_hdr)];

void __svio_init_emu(void)
{
    svioparse_init(2);

    __svio_ioshm = __svio_ioshm_emu;
    __svio_hdr = (struct ioshm_hdr*)__svio_ioshm;
    __svio_hdr->idata_offset = sizeof(*__svio_hdr);
    __svio_hdr->idata_bufsize = SVIO_OOFFSET;
    __svio_hdr->odata_offset = SVIO_OOFFSET + sizeof(*__svio_hdr);
    __svio_hdr->odata_bufsize = SVIO_SIZE - SVIO_OOFFSET;

    __svio_obegin = __svio_ioshm + __svio_hdr->odata_offset;
    __svio_olimit = __svio_obegin + __svio_hdr->odata_bufsize;
    __svio_ocursor = __svio_obegin;
}

void __svio_refill_emu(void)
{
    void* begin = __svio_ioshm + __svio_hdr->idata_offset;
    void* limit = begin + __svio_hdr->idata_bufsize;

    int len = svioparse_next_chunk(begin, limit);

    __svio_icursor = __svio_ioshm + __svio_hdr->idata_offset;
    __svio_iend = __svio_icursor + len;
}

void __svio_flush_emu(void)
{
    int size = __svio_ocursor - __svio_obegin;

    int err = svioparse_flush_obuf(__svio_obegin,
            __svio_obegin + size);
    if (err < 0)
        exit(121);
    
    __svio_ocursor = __svio_obegin;
}

