#include <stdlib.h>
#include <string.h>

#include "supervisor.h"
#include "prototypes.h"
#include "ioshm.h"

#include "libsvioparse/svioparse.h"

static int init_done;

static void check_init(void)
{
    if (init_done) return;
    svioparse_init(2);
    init_done = 1;
}

static int next_chunk(void)
{
    void* ch_cursor = ioshm+ioshm_hdr_shadow->idata_offset;
    void* ch_limit = ioshm+ioshm_hdr_shadow->odata_offset;

    check_init();

    ioshm_hdr->idata_bufsize = svioparse_next_chunk(ch_cursor, ch_limit);
    
    return 0;
}

int sys_iochunk(long sysnr)
{
    emulate_syscall(next_chunk());
    return 0;
}


static int flush_obuf(void)
{
    void* fl_cursor = ioshm+ioshm_hdr_shadow->odata_offset;
    void* fl_limit = fl_cursor+ioshm_hdr->odata_bufsize;
    int err;

    check_init();

    err = svioparse_flush_obuf(fl_cursor, fl_limit);

    if (err == -1)
        forbidden("bad svio interaction");
    else if (err == -2)
        fail_tracker("svio output error");
    else if (err < 0)
        fail_tracker("unknown svio error");

    return 0;
}

int sys_ioflush(long sysnr)
{
    emulate_syscall(flush_obuf());
    return 0;
}


