#include <stdlib.h>
#include <sys/syscall.h>
#include "esyscall.h"

#include "supervisor.h"

static const char* syscall_names[MAX_SYSNR] = {
	[__NR_restart_syscall] = "restart_syscall",
	[__NR_exit] = "exit",
	[__NR_fork] = "fork",
	[__NR_read] = "read",
	[__NR_write] = "write",
	[__NR_open] = "open",
	[__NR_close] = "close",
	[__NR_waitpid] = "waitpid",
	[__NR_creat] = "creat",
	[__NR_link] = "link",
	[__NR_unlink] = "unlink",
	[__NR_execve] = "execve",
	[__NR_chdir] = "chdir",
	[__NR_time] = "time",
	[__NR_mknod] = "mknod",
	[__NR_chmod] = "chmod",
	[__NR_lchown] = "lchown",
	[__NR_break] = "break",
	[__NR_oldstat] = "oldstat",
	[__NR_lseek] = "lseek",
	[__NR_getpid] = "getpid",
	[__NR_mount] = "mount",
	[__NR_umount] = "umount",
	[__NR_setuid] = "setuid",
	[__NR_getuid] = "getuid",
	[__NR_stime] = "stime",
	[__NR_ptrace] = "ptrace",
	[__NR_alarm] = "alarm",
	[__NR_oldfstat] = "oldfstat",
	[__NR_pause] = "pause",
	[__NR_utime] = "utime",
	[__NR_stty] = "stty",
	[__NR_gtty] = "gtty",
	[__NR_access] = "access",
	[__NR_nice] = "nice",
	[__NR_ftime] = "ftime",
	[__NR_sync] = "sync",
	[__NR_kill] = "kill",
	[__NR_rename] = "rename",
	[__NR_mkdir] = "mkdir",
	[__NR_rmdir] = "rmdir",
	[__NR_dup] = "dup",
	[__NR_pipe] = "pipe",
	[__NR_times] = "times",
	[__NR_prof] = "prof",
	[__NR_brk] = "brk",
	[__NR_setgid] = "setgid",
	[__NR_getgid] = "getgid",
	[__NR_signal] = "signal",
	[__NR_geteuid] = "geteuid",
	[__NR_getegid] = "getegid",
	[__NR_acct] = "acct",
	[__NR_umount2] = "umount2",
	[__NR_lock] = "lock",
	[__NR_ioctl] = "ioctl",
	[__NR_fcntl] = "fcntl",
	[__NR_mpx] = "mpx",
	[__NR_setpgid] = "setpgid",
	[__NR_ulimit] = "ulimit",
	[__NR_oldolduname] = "oldolduname",
	[__NR_umask] = "umask",
	[__NR_chroot] = "chroot",
	[__NR_ustat] = "ustat",
	[__NR_dup2] = "dup2",
	[__NR_getppid] = "getppid",
	[__NR_getpgrp] = "getpgrp",
	[__NR_setsid] = "setsid",
	[__NR_sigaction] = "sigaction",
	[__NR_sgetmask] = "sgetmask",
	[__NR_ssetmask] = "ssetmask",
	[__NR_setreuid] = "setreuid",
	[__NR_setregid] = "setregid",
	[__NR_sigsuspend] = "sigsuspend",
	[__NR_sigpending] = "sigpending",
	[__NR_sethostname] = "sethostname",
	[__NR_setrlimit] = "setrlimit",
	[__NR_getrlimit] = "getrlimit",
	[__NR_getrusage] = "getrusage",
	[__NR_gettimeofday] = "gettimeofday",
	[__NR_settimeofday] = "settimeofday",
	[__NR_getgroups] = "getgroups",
	[__NR_setgroups] = "setgroups",
	[__NR_select] = "select",
	[__NR_symlink] = "symlink",
	[__NR_oldlstat] = "oldlstat",
	[__NR_readlink] = "readlink",
	[__NR_uselib] = "uselib",
	[__NR_swapon] = "swapon",
	[__NR_reboot] = "reboot",
	[__NR_readdir] = "readdir",
	[__NR_mmap] = "mmap",
	[__NR_munmap] = "munmap",
	[__NR_truncate] = "truncate",
	[__NR_ftruncate] = "ftruncate",
	[__NR_fchmod] = "fchmod",
	[__NR_fchown] = "fchown",
	[__NR_getpriority] = "getpriority",
	[__NR_setpriority] = "setpriority",
	[__NR_profil] = "profil",
	[__NR_statfs] = "statfs",
	[__NR_fstatfs] = "fstatfs",
	[__NR_ioperm] = "ioperm",
	[__NR_socketcall] = "socketcall",
	[__NR_syslog] = "syslog",
	[__NR_setitimer] = "setitimer",
	[__NR_getitimer] = "getitimer",
	[__NR_stat] = "stat",
	[__NR_lstat] = "lstat",
	[__NR_fstat] = "fstat",
	[__NR_olduname] = "olduname",
	[__NR_iopl] = "iopl",
	[__NR_vhangup] = "vhangup",
	[__NR_idle] = "idle",
	[__NR_vm86old] = "vm86old",
	[__NR_wait4] = "wait4",
	[__NR_swapoff] = "swapoff",
	[__NR_sysinfo] = "sysinfo",
	[__NR_ipc] = "ipc",
	[__NR_fsync] = "fsync",
	[__NR_sigreturn] = "sigreturn",
	[__NR_clone] = "clone",
	[__NR_setdomainname] = "setdomainname",
	[__NR_uname] = "uname",
	[__NR_modify_ldt] = "modify_ldt",
	[__NR_adjtimex] = "adjtimex",
	[__NR_mprotect] = "mprotect",
	[__NR_sigprocmask] = "sigprocmask",
	[__NR_create_module] = "create_module",
	[__NR_init_module] = "init_module",
	[__NR_delete_module] = "delete_module",
	[__NR_get_kernel_syms] = "get_kernel_syms",
	[__NR_quotactl] = "quotactl",
	[__NR_getpgid] = "getpgid",
	[__NR_fchdir] = "fchdir",
	[__NR_bdflush] = "bdflush",
	[__NR_sysfs] = "sysfs",
	[__NR_personality] = "personality",
	[__NR_afs_syscall] = "afs_syscall",
	[__NR_setfsuid] = "setfsuid",
	[__NR_setfsgid] = "setfsgid",
	[__NR__llseek] = "_llseek",
	[__NR_getdents] = "getdents",
	[__NR__newselect] = "_newselect",
	[__NR_flock] = "flock",
	[__NR_msync] = "msync",
	[__NR_readv] = "readv",
	[__NR_writev] = "writev",
	[__NR_getsid] = "getsid",
	[__NR_fdatasync] = "fdatasync",
	[__NR__sysctl] = "_sysctl",
	[__NR_mlock] = "mlock",
	[__NR_munlock] = "munlock",
	[__NR_mlockall] = "mlockall",
	[__NR_munlockall] = "munlockall",
	[__NR_sched_setparam] = "sched_setparam",
	[__NR_sched_getparam] = "sched_getparam",
	[__NR_sched_setscheduler] = "sched_setscheduler",
	[__NR_sched_getscheduler] = "sched_getscheduler",
	[__NR_sched_yield] = "sched_yield",
	[__NR_sched_get_priority_max] = "sched_get_priority_max",
	[__NR_sched_get_priority_min] = "sched_get_priority_min",
	[__NR_sched_rr_get_interval] = "sched_rr_get_interval",
	[__NR_nanosleep] = "nanosleep",
	[__NR_mremap] = "mremap",
	[__NR_setresuid] = "setresuid",
	[__NR_getresuid] = "getresuid",
	[__NR_vm86] = "vm86",
	[__NR_query_module] = "query_module",
	[__NR_poll] = "poll",
	[__NR_nfsservctl] = "nfsservctl",
	[__NR_setresgid] = "setresgid",
	[__NR_getresgid] = "getresgid",
	[__NR_prctl] = "prctl",
	[__NR_rt_sigreturn] = "rt_sigreturn",
	[__NR_rt_sigaction] = "rt_sigaction",
	[__NR_rt_sigprocmask] = "rt_sigprocmask",
	[__NR_rt_sigpending] = "rt_sigpending",
	[__NR_rt_sigtimedwait] = "rt_sigtimedwait",
	[__NR_rt_sigqueueinfo] = "rt_sigqueueinfo",
	[__NR_rt_sigsuspend] = "rt_sigsuspend",
	[__NR_pread64] = "pread64",
	[__NR_pwrite64] = "pwrite64",
	[__NR_chown] = "chown",
	[__NR_getcwd] = "getcwd",
	[__NR_capget] = "capget",
	[__NR_capset] = "capset",
	[__NR_sigaltstack] = "sigaltstack",
	[__NR_sendfile] = "sendfile",
	[__NR_getpmsg] = "getpmsg",
	[__NR_putpmsg] = "putpmsg",
	[__NR_vfork] = "vfork",
	[__NR_ugetrlimit] = "ugetrlimit",
	[__NR_mmap2] = "mmap2",
	[__NR_truncate64] = "truncate64",
	[__NR_ftruncate64] = "ftruncate64",
	[__NR_stat64] = "stat64",
	[__NR_lstat64] = "lstat64",
	[__NR_fstat64] = "fstat64",
	[__NR_lchown32] = "lchown32",
	[__NR_getuid32] = "getuid32",
	[__NR_getgid32] = "getgid32",
	[__NR_geteuid32] = "geteuid32",
	[__NR_getegid32] = "getegid32",
	[__NR_setreuid32] = "setreuid32",
	[__NR_setregid32] = "setregid32",
	[__NR_getgroups32] = "getgroups32",
	[__NR_setgroups32] = "setgroups32",
	[__NR_fchown32] = "fchown32",
	[__NR_setresuid32] = "setresuid32",
	[__NR_getresuid32] = "getresuid32",
	[__NR_setresgid32] = "setresgid32",
	[__NR_getresgid32] = "getresgid32",
	[__NR_chown32] = "chown32",
	[__NR_setuid32] = "setuid32",
	[__NR_setgid32] = "setgid32",
	[__NR_setfsuid32] = "setfsuid32",
	[__NR_setfsgid32] = "setfsgid32",
	[__NR_pivot_root] = "pivot_root",
	[__NR_mincore] = "mincore",
	[__NR_madvise] = "madvise",
	[__NR_madvise1] = "madvise1",
	[__NR_getdents64] = "getdents64",
	[__NR_fcntl64] = "fcntl64",
	[__NR_gettid] = "gettid",
	[__NR_readahead] = "readahead",
	[__NR_setxattr] = "setxattr",
	[__NR_lsetxattr] = "lsetxattr",
	[__NR_fsetxattr] = "fsetxattr",
	[__NR_getxattr] = "getxattr",
	[__NR_lgetxattr] = "lgetxattr",
	[__NR_fgetxattr] = "fgetxattr",
	[__NR_listxattr] = "listxattr",
	[__NR_llistxattr] = "llistxattr",
	[__NR_flistxattr] = "flistxattr",
	[__NR_removexattr] = "removexattr",
	[__NR_lremovexattr] = "lremovexattr",
	[__NR_fremovexattr] = "fremovexattr",
	[__NR_tkill] = "tkill",
	[__NR_sendfile64] = "sendfile64",
	[__NR_futex] = "futex",
	[__NR_sched_setaffinity] = "sched_setaffinity",
	[__NR_sched_getaffinity] = "sched_getaffinity",
	[__NR_set_thread_area] = "set_thread_area",
	[__NR_get_thread_area] = "get_thread_area",
	[__NR_io_setup] = "io_setup",
	[__NR_io_destroy] = "io_destroy",
	[__NR_io_getevents] = "io_getevents",
	[__NR_io_submit] = "io_submit",
	[__NR_io_cancel] = "io_cancel",
	[__NR_fadvise64] = "fadvise64",
	[__NR_exit_group] = "exit_group",
	[__NR_lookup_dcookie] = "lookup_dcookie",
	[__NR_epoll_create] = "epoll_create",
	[__NR_epoll_ctl] = "epoll_ctl",
	[__NR_epoll_wait] = "epoll_wait",
	[__NR_remap_file_pages] = "remap_file_pages",
	[__NR_set_tid_address] = "set_tid_address",
	[__NR_timer_create] = "timer_create",
	[__NR_timer_settime] = "timer_settime",
	[__NR_timer_gettime] = "timer_gettime",
	[__NR_timer_getoverrun] = "timer_getoverrun",
	[__NR_timer_delete] = "timer_delete",
	[__NR_clock_settime] = "clock_settime",
	[__NR_clock_gettime] = "clock_gettime",
	[__NR_clock_getres] = "clock_getres",
	[__NR_clock_nanosleep] = "clock_nanosleep",
	[__NR_statfs64] = "statfs64",
	[__NR_fstatfs64] = "fstatfs64",
	[__NR_tgkill] = "tgkill",
	[__NR_utimes] = "utimes",
	[__NR_fadvise64_64] = "fadvise64_64",
	[__NR_vserver] = "vserver",
	[__NR_mbind] = "mbind",
	[__NR_get_mempolicy] = "get_mempolicy",
	[__NR_set_mempolicy] = "set_mempolicy",
	[__NR_mq_open] = "mq_open",
	[__NR_mq_unlink] = "mq_unlink",
	[__NR_mq_timedsend] = "mq_timedsend",
	[__NR_mq_timedreceive] = "mq_timedreceive",
	[__NR_mq_notify] = "mq_notify",
	[__NR_mq_getsetattr] = "mq_getsetattr",

    [__NRe_ioshmget] = "e_ioshmget",
    [__NRe_ioshmat] = "e_ioshmat",
    [__NRe_iochunk] = "e_iochunk",
};

const char* syscall_name(int sysnr) {
    if (sysnr < 0 || sysnr >= MAX_SYSNR || syscall_names[sysnr] == NULL)
        return "<unknown>";
    return syscall_names[sysnr];
}

