#ifndef _SUPERVISOR_PROTOYPES_H
#define _SUPERVISOR_PROTOYPES_H

#include <sys/types.h>
#include <sys/resource.h>

/* supervisor.c */
void fail_tracker(const char* str);
void report_result(int retval, const char* comment);
void report_result_chklim(int retval, const char* comment);
long uread(long offset);
void uwrite(long offset, long value);
void track_memory(void);
void track_exectime(void);
void zero_exectime(void);
void kill_and_exit(void);
void forbidden(const char* msg);
void skip_syscall(void);
void emulate_syscall(int retval);
void change_syscall(long sysnr);

extern short sc_state;
extern long used_memory;
extern long max_memory;
extern unsigned long long exectime;
extern unsigned long long exectime_offset;
extern int enable_extensions, force_extensions;
extern int count_systime;
extern long time_limit;
extern long hard_time_limit;
extern long mem_limit;
extern long out_limit;
extern int allow_all;
extern int quiet;
extern pid_t tracked;
extern struct rusage res_usage;

/* quirks.h */
extern int execve_called;
int quirk_syscall(long sysnr);

/* scnames.c */
const char* syscall_name(int sysnr);

/* policy.c */
extern short syscall_flags[];

/* ioshm.c */
void init_ioshm(void);
int sys_ioshmget(long sysnr);
int sys_ioshmat(long sysnr);

struct ioshm_hdr;

extern void* ioshm;
extern struct ioshm_hdr* ioshm_hdr;
extern struct ioshm_hdr* ioshm_hdr_shadow;

/* iomap.c */
void iomap_entire_stdin(void);

extern void* iomap_data;
extern int   iomap_size;

/* parser.c */
void init_parser(void);
int sys_iochunk(long sysnr);
int sys_ioflush(long sysnr);


#endif
