#define READ_BEGIN \
    pushl %esi; \
    movl __svio_icursor, %esi; \
    call cond_refill

#define READ_END \
    movl %esi, __svio_icursor; \
    popl %esi; \
    ret

#ifdef STRICT_CHECKING
#define CHECK_FORMAT(fmt) \
    movb $fmt, %al; \
    call check_format
#else
#define CHECK_FORMAT(fmt)
#endif

    .text

cond_refill:
    cmpl %esi, __svio_iend
    jne  1f
    call __svio_refill
    movl __svio_icursor, %esi
1:
    ret

check_format:
    cmpb %al, (%esi)
    je   1f
    call __svio_formaterror
1:
    ret

.globl read_int
.globl read_uint
.globl read_longlong
.globl read_ulonglong
read_int:
read_uint:
read_longlong:
read_ulonglong:
    READ_BEGIN
    CHECK_FORMAT('N')
    movl 1(%esi), %eax
    movl 5(%esi), %edx
    addl $9, %esi
    READ_END
    
.globl read_string
read_string:
    READ_BEGIN
    CHECK_FORMAT('S')
    pushl %edi
    movl 12(%esp), %edi
    movl 1(%esi), %ecx
    addl $5, %esi
1:
    movsb
    cmpl __svio_iend, %esi
    jne  2f
    pushl %ecx
    call __svio_refill
    popl %ecx
    movl __svio_icursor, %esi
2:
    loop 1b
    movb $0, (%edi)
    popl %edi
    READ_END

.globl read_strlen
read_strlen:
    READ_BEGIN
    CHECK_FORMAT('S')
    movl 1(%esi), %eax
    addl $5, %esi
    READ_END

.globl read_char
read_char:
    READ_BEGIN
    movb (%esi), %al
    incl %esi
    READ_END


